/*
 * Decompiled with CFR 0.152.
 */
package com.webcodepro.applecommander.ui.swt.filteradapter;

import com.webcodepro.applecommander.ui.swt.FileViewerWindow;
import com.webcodepro.applecommander.ui.swt.filteradapter.FilterAdapter;
import com.webcodepro.applecommander.ui.swt.util.contentadapter.StyledTextAdapter;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;

public class TextFilterAdapter
extends FilterAdapter {
    private String textContent;

    public TextFilterAdapter(FileViewerWindow window, String text, String toolTipText, Image image) {
        super(window, text, toolTipText, image);
    }

    @Override
    public void display() {
        if (this.textContent == null) {
            this.textContent = this.createTextContent();
        }
        this.getCopyToolItem().setEnabled(true);
        this.createTextWidget(this.textContent);
    }

    protected String createTextContent() {
        return new String(this.getFileFilter().filter(this.getFileEntry()));
    }

    protected void createTextWidget(String textContents) {
        StyledText styledText = new StyledText(this.getComposite(), 0);
        styledText.setText(textContents);
        styledText.setFont(this.getCourierFont());
        styledText.setEditable(false);
        Point size = styledText.computeSize(-1, -1, true);
        this.getComposite().setContent(styledText);
        this.getComposite().setExpandHorizontal(true);
        this.getComposite().setExpandVertical(true);
        this.getComposite().setMinWidth(size.x);
        this.getComposite().setMinHeight(size.y);
        this.getComposite().getContent().addListener(2, this.getToolbarCommandHandler());
        this.getToolItem().setSelection(true);
        this.setContentTypeAdapter(new StyledTextAdapter(styledText, this.getFileEntry().getFilename()));
    }
}

